<?php

function generate_config()
{
    include_once("../config/node_parameters.php");  /* DO NOT DELETE THIS LINE */ //All link parameters
    
    
return "
# JUNIPER Configuration on device IP: $IP
# ########################################################################## !!

##### Interface config ########################################################################################
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC description $MAP_NAME
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet filter input $MAP_NAME-IN
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet filter output $MAP_NAME-OUT
#set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet policer arp ARP-LIMIT
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet policer input $MAP_NAME-IN
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet policer output $MAP_NAME-OUT
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet address $IP_P2P_GATEWAY/$IP_P2P_MASK

##### IN filter  #####################################################################################
set  firewall filter $MAP_NAME-IN term T1 from destination-address $IP_P2P_GATEWAY/32
set  firewall filter $MAP_NAME-IN term T1 from protocol icmp
set  firewall filter $MAP_NAME-IN term T1 then accept
set  firewall filter $MAP_NAME-IN term T2 from destination-address $IP_P2P_GATEWAY/32
set  firewall filter $MAP_NAME-IN term T2 from protocol tcp
set  firewall filter $MAP_NAME-IN term T2 then discard
#set  firewall filter $MAP_NAME-IN term T3 from destination-address 192.168.0.0/16
#set  firewall filter $MAP_NAME-IN term T3 from destination-address 172.16.0.0/12
#set  firewall filter $MAP_NAME-IN term T3 from destination-address 10.0.0.0/8
#set  firewall filter $MAP_NAME-IN term T3 then discard
set  firewall filter $MAP_NAME-IN term T4 from source-address $IP_P2P

##### PA IP address ########################################################################################
set  firewall filter $MAP_NAME-IN term T4 from source-address $IP_PA
#set  firewall filter $MAP_NAME-IN term T4 then dscp 0
set  firewall filter $MAP_NAME-IN term T4 then accept
set  firewall filter $MAP_NAME-IN term T5 then discard


##### OUT filter ############################################################################################
set  firewall filter $MAP_NAME-OUT term T1 from destination-address $IP_P2P
set  firewall filter $MAP_NAME-OUT term T1 from destination-address $IP_PA
set  firewall filter $MAP_NAME-OUT term T1 then accept
set  firewall filter $MAP_NAME-OUT term T2 then discard

##### Policers ##############################################################################################

set  firewall policer $MAP_NAME-IN if-exceeding bandwidth-limit $UPLOAD
set  firewall policer $MAP_NAME-IN if-exceeding burst-size-limit 10m
set  firewall policer $MAP_NAME-IN then discard

set  firewall policer $MAP_NAME-OUT if-exceeding bandwidth-limit $DOWNLOAD
set  firewall policer $MAP_NAME-OUT if-exceeding burst-size-limit 10m
set  firewall policer $MAP_NAME-OUT then discard


#### Static route ##########################################################################################

set  routing-options static route $IP_PA next-hop $IP_NEXT_HOP

#set  policy-options policy-statement BGP_STATIC term static from route-filter $IP_PA orlonger

#### BGP STATIC Policy #######################################################################################
#set policy-options policy-statement BGP_STATIC term static from protocol static
#set policy-options policy-statement BGP_STATIC term static from route-filter $IP_PA orlonger
#set policy-options policy-statement BGP_STATIC term static then community add 21021:9000
#set policy-options policy-statement BGP_STATIC term static then next-hop self
#set policy-options policy-statement BGP_STATIC term static then accept
#set policy-options policy-statement BGP_STATIC term direct from protocol direct
#set policy-options policy-statement BGP_STATIC term direct then community add 21021:9000
#set policy-options policy-statement BGP_STATIC term direct then next-hop self
#set policy-options policy-statement BGP_STATIC term direct then accept
#set policy-options policy-statement BGP_STATIC term bgp from protocol bgp
#set policy-options policy-statement BGP_STATIC term bgp then accept
#set policy-options policy-statement BGP_STATIC term implicit-deny then reject

##### ARP Policer ##############################################################################################
#set firewall policer ARP-LIMIT if-exceeding bandwidth-limit 8k
#set firewall policer ARP-LIMIT if-exceeding burst-size-limit 1500
#set firewall policer ARP-LIMIT then discard
		
";

}

?>
